
import cadquery as cq

# Define the dimensions of the rectangle
length = 1.0
width = 0.1
thickness = 1.25

# Define the dimensions of the hole
hole_length = length / 8
hole_width = width / 8

# Create the rectangle and extrude it
result = (
    cq.Workplane("XY")
    .rect(length, width)
    .extrude(thickness)
)

# Create the hole
result = (
    result.faces(">Z")
    .workplane(centerOption="CenterOfBoundBox")
    .rect(hole_length, hole_width)
    .cutBlind(-thickness/2)
)

# Export the result
result.val().exportStl("Refine_1.stl")
