
import cadquery as cq

# Define the dimensions of the rectangle
length = 1.0
width = 0.1
thickness = 1.25

# Define the dimensions of the hole
hole_length = length / 8
hole_width = width / 8

# Create the rectangle and extrude it
result = (
    cq.Workplane("XY")
    .rect(length, width)
    .extrude(thickness)
)

# Modify the hole creation process, move hole closer to the bottom
result = (
    result.faces(">Z")
    .workplane(invert=True)
    .center(0, -width/2 + hole_width/2)
    .rect(hole_length, hole_width)
    .cutBlind(-thickness/2)
)

# Export the result
result.val().exportStl("Refine_2.stl")
