
import cadquery as cq

# Define the dimensions of the cylinders
large_cylinder_diameter = 0.12
large_cylinder_height = 0.84
small_cylinder_diameter = large_cylinder_diameter / 2
small_cylinder_height = large_cylinder_height * 5

# Create the large cylinder
result = cq.Workplane("XY").circle(large_cylinder_diameter / 2).extrude(large_cylinder_height)

# Create the small cylinder at the bottom of the large cylinder
result = result.faces("<Z").workplane().circle(small_cylinder_diameter / 2).extrude(-small_cylinder_height)

# Export the result
result.val().exportStl("Refine_2.stl")
