
import cadquery as cq

# Define the dimensions
width = 15.0
height = 1.0
thickness = 0.2
hole_width = width / 3.0
hole_height = height / 2.0
hole_spacing = width / 6.0

# Create the base rectangle
result = cq.Workplane("XY").box(width, height, thickness)

# Create the holes
result = (
    result.faces(">Z")
    .workplane()
    .rect(hole_width, hole_height, forConstruction=True)
    .vertices("<XY")
    .rect(hole_width, hole_height)
    .vertices(">XY")
    .rect(hole_width, hole_height)
    .cutBlind(-thickness)
)

# Export the result
result.val().exportStl("Refine_1.stl")
