
import cadquery as cq

# Define the side length and radius of the rounded square
side_length = 10.0
radius = 1.0

# Create a rounded square by making a square and then filleting the corners
result = (
    cq.Workplane("XY")
    .rect(side_length, side_length)
    .extrude(5.0)  # Extrude the square to create a 3D object
    .edges().fillet(radius)  # Apply fillet on the 3D Object edges
)

# Export the result to an STL file
result.val().exportStl("Refine_1.stl")
