
import cadquery as cq

# Create a large hollow cylinder
outer_radius = 50.0
inner_radius = 45.0
height = 100.0
result = cq.Workplane("XY").circle(outer_radius).circle(inner_radius).extrude(height)

# Create a circle at the bottom of the cylinder to close it
result = result.faces("<Z").workplane().circle(outer_radius).extrude(5)

# Create a tiny hollow circle in the middle of the circle
tiny_outer_radius = 5.0
tiny_inner_radius = 3.0
result = result.faces(">Z").workplane().center(0, 0).circle(tiny_outer_radius).circle(tiny_inner_radius).extrude(5)

# Save the output
result.val().exportStl("Refine_1.stl")
