
import cadquery as cq

outer_radius = 10   # specify the outer_radius
inner_radius = 5    # specify the inner_radius
height = 15         # specify the height
tiny_outer_radius = 2  # specify the tiny_outer_radius
tiny_inner_radius = 1  # specify the tiny_inner_radius

# Create a large hollow cylinder
result = cq.Workplane("XY").circle(outer_radius).circle(inner_radius).extrude(height)

# Create a circle at the bottom of the cylinder to close it
result = result.faces("<Z").workplane().circle(outer_radius).extrude(height)

# Create a tiny hollow circle in the middle of the circle
result = result.faces(">Z").workplane().center(0, 0).circle(tiny_outer_radius).circle(tiny_inner_radius).extrude(5)

# Save the output
result.val().exportStl("Refine_2.stl")
