
import cadquery as cq

# Define the dimensions of the trapezoids
base1 = 1.2
base2 = 0.7
height = 2.2
extrude_dist1 = 0.75
extrude_dist2 = 0.15

# Create the first trapezoid
result = (
    cq.Workplane("front")
    .lineTo(base1 / 2, 0)
    .lineTo(base2 / 2, height)
    .lineTo(-base2 / 2, height)
    .lineTo(-base1 / 2, 0)
    .close()
    .extrude(extrude_dist1)
)

# Create the second trapezoid
result2 = (
    cq.Workplane("front")
    .workplane(offset=extrude_dist1)
    .lineTo((base1 + 0.2) / 2, 0)
    .lineTo((base2 + 0.2) / 2, height + 0.2)
    .lineTo(-(base2 + 0.2) / 2, height + 0.2)
    .lineTo(-(base1 + 0.2) / 2, 0)
    .close()
    .extrude(extrude_dist2)
)

# Combine the two trapezoids
result = result.union(result2)

# Export the result
result.val().exportStl("Refine_2.stl")
