
import cadquery as cq

# Define the dimensions of the rectangles
large_rectangle_length = 0.42
large_rectangle_width = 0.24
small_rectangle_length = large_rectangle_length / 2
small_rectangle_width = large_rectangle_width / 2

# Define the extrusion amounts
large_rectangle_extrusion = 0.75
small_rectangle_extrusion = large_rectangle_extrusion * 2

# Create the large rectangle in the X-Y plane
large_rectangle = (
    cq.Workplane("XY")
    .rect(large_rectangle_length, large_rectangle_width)
    .extrude(large_rectangle_extrusion)
)

# Create the small rectangle in the Y-Z plane, centered at the same point as the large rectangle
small_rectangle = (
    cq.Workplane("YZ", origin=(large_rectangle_length / 2, 0, 0))
    .rect(small_rectangle_length, small_rectangle_width)
    .extrude(small_rectangle_extrusion)
)

# Combine the two rectangles
result = large_rectangle.union(small_rectangle)

# Export the result
result.val().exportStl("Refine_2.stl")
