
import cadquery as cq

# These can be modified rather than hardcoding values for each dimension.
diameter = 100.0  # Diameter of the cylinder
height = 10.0  # Height of the cylinder

result = (
    cq.Workplane("XY")
    .circle(diameter / 2.0)
    .extrude(height)
)

result.val().exportStl("Generated.stl")
