
import cadquery as cq

# Define the dimensions of the pipe
length = 0.19  # Length of the pipe
width = 0.75  # Width of the pipe
height = 0.19  # Height of the pipe
thickness = 0.01  # Wall thickness of the pipe

# Create the outer part of the pipe
pipe_outer = cq.Workplane("front").box(length, width, height)

# Create the inner part of the pipe
pipe_inner = cq.Workplane("front").box(length - 2*thickness, width - 2*thickness, height - 2*thickness).translate((0,0,thickness))

# Subtract the inner part from the outer part to create the pipe
pipe = pipe_outer.cut(pipe_inner)

# Export the result
pipe.val().exportStl("Refine_2.stl")
