
import cadquery as cq

# Define the dimensions of the pipe
length = 1.2  # Length of the pipe
width = 0.3  # Width of the pipe
height = 0.06  # Height of the pipe
thickness = 0.01  # Wall thickness of the pipe

# Create the outer part of the pipe
outer = cq.Workplane("front").box(length, width, height)

# Create the inner part of the pipe
inner = (
    cq.Workplane("front")
    .box(length - 2 * thickness, width - 2 * thickness, height)
    .translate((thickness, thickness, 0))
)

# Subtract the inner part from the outer part to create the pipe
pipe = outer.cut(inner)

# Export the result
pipe.val().exportStl("Refine_2.stl")
