py
import cadquery as cq

# Define the dimensions of the rectangle and the cutouts
rect_length = 10.0
rect_width = 5.0
cutout_size = 1.0

# Create the rectangle and extrude it first
result = cq.Workplane("XY").rect(rect_length, rect_width).extrude(1.0)

# Create the cutouts at each corner
result = result.faces(">Z").vertices("<XY").rect(cutout_size, cutout_size).cutBlind(-1.0)
result = result.faces(">Z").vertices(">XY").rect(cutout_size, cutout_size).cutBlind(-1.0)
result = result.faces(">Z").vertices("<X>Y").rect(cutout_size, cutout_size).cutBlind(-1.0)
result = result.faces(">Z").vertices(">X<Y").rect(cutout_size, cutout_size).cutBlind(-1.0)

# Save the result
result.val().exportStl("Generated.stl")
