
import cadquery as cq

# Define the parameters of the ring
outer_radius = 3.0
inner_radius = 1.5
thickness = 0.26

# Create the ring
result = (
    cq.Workplane("XY")
    .circle(outer_radius)
    .circle(inner_radius)
    .extrude(thickness)
)

# Export the result
result.val().exportStl("Refine_2.stl")
