
import cadquery as cq

# Create a rectangular sketch and extrude it
result = cq.Workplane("front").rect(1.5, 2).extrude(0.05)

# Add two small holes on the left side of the rectangle
result = result.faces("<X").workplane().pushPoints([(0.375, 0.75), (0.375, -0.75)]).hole(0.1)

# Export the result
result.val().exportStl("Refine_2.stl")
