
import cadquery as cq

# Define the dimensions of the rectangle and trapezium
rect_length = 0.75
rect_width = 0.05
trap_height = 0.14
trap_top_length = 0.75

# Create the rectangle
result = cq.Workplane("front").rect(rect_length, rect_width)

# Move to the top center of the rectangle
result = result.moveTo(rect_length / 2, rect_width)

# Draw the trapezium
result = result.lineTo(-(trap_top_length / 2), trap_height)
result = result.lineTo(trap_top_length / 2, trap_height)
result = result.lineTo(trap_top_length / 2, 0)
result = result.lineTo(-(trap_top_length / 2), 0)

# Close the sketch and extrude
result = result.close().extrude(rect_width)

# Export the result
result.val().exportStl("Refine_2.stl")
