
import cadquery as cq
import math

# Define the dimensions
rect_length = 0.78
rect_width = 0.61
trap_base = rect_width * 2 / 3
trap_height = trap_base / 10
extrude_amount = 0.02

# Create the rectangle
result = cq.Workplane("front").rect(rect_length, rect_width)

# Calculate the coordinates for the trapezium
trap_top = trap_base - 2 * trap_height / math.tan(math.radians(45))
trap_top_x = rect_length / 2 - trap_top / 2
trap_base_x = rect_length / 2 - trap_base / 2

# Create the trapezium
result = result.moveTo(trap_base_x, rect_width).lineTo(trap_base_x + trap_base, rect_width).\
    lineTo(trap_top_x + trap_top, rect_width + trap_height).\
    lineTo(trap_top_x, rect_width + trap_height).close()

# Extrude the sketch
result = result.extrude(extrude_amount)

# Export the result
result.val().exportStl("Refine_1.stl")
