
import cadquery as cq

# Define the points for the triangles
points = [
    (0, 0),  # Start point
    (0.34, 0.75),  # First peak
    (0.68, 0),  # Base between first and second peak
    (1.02, 0.75),  # Second peak (equilateral triangle)
    (1.36, 0),  # Base between second and third peak
    (1.7, 0.75),  # Third peak
    (2.04, 0)   # End point
]

# Create the profile and extrude it
result = cq.Workplane("front").polyline(points).close().extrude(0.14)

# Export the result
result.val().exportStl("Refine_1.stl")
