
# Updated Python CADQuery code to create a long L-shaped bracket

import cadquery as cq

# Define the points for the polyline to create the updated sketch of the L bracket
points = [(0, 0), (0, 0.15), (0.75, 0.15), (0.75, 0.14), (0.01, 0.14), (0.01, 0)]

# Create a workplane and draw the updated L shape using the polyline function
result = cq.Workplane("front").polyline(points).close()

# Extrude the updated L shape to create the 3D bracket
result = result.extrude(0.4)   # Updated extrusion value

# Export the result to an STL file
result.val().exportStl("Refine_2.stl")
