
import cadquery as cq

# Create a cylinder
cylinder = cq.Workplane("XY").circle(10).extrude(20)

# Create a hole in the cylinder
cylinder_with_hole = cylinder.faces(">Z").workplane().circle(5).cutThruAll()

# Create a square on the outer edge of the cylinder
square = cq.Workplane("XY").rect(2, 2).extrude(20)

# Combine the cylinder with hole and the square
result = cylinder_with_hole.union(square)

# Export the result
result.val().exportStl("Refine_1.stl")
