
import cadquery as cq

# Create a cylinder
cylinder = cq.Workplane("XY").circle(10).extrude(20)

# Create a hole in the cylinder
cylinder_with_hole = cylinder.faces(">Z").workplane().circle(5).cutThruAll()

# Create a cutting tool
cutting_tool = (
    cq.Workplane("XY")
    .moveTo(10, 0)
    .rect(2, 2)
    .extrude(20)
)

# Cut the channel into the cylinder
cylinder_with_channel = cylinder_with_hole.cut(cutting_tool)

# Export the result
cylinder_with_channel.val().exportStl("Refine_2.stl")
