
import cadquery as cq

# Create a rectangular object
result = cq.Workplane("front").rect(0.75, 0.38).extrude(0.02)

# Create a small circular hole in the top right corner
result = result.faces(">Z").workplane().center(0.375, 0.19).hole(0.01)

# Save the output
result.val().exportStl("Refine_2.stl")
