
import cadquery as cq

# Define the points for the trapezoid
points = [(0, 0), (1.5, 0), (1, 0.59), (0.5, 0.59)]

# Create a workplane and draw the trapezoid
r = cq.Workplane("front").polyline(points).close()

# Extrude the trapezoid to create a prism
result = r.extrude(0.38)

# Export the result
result.val().exportStl("Refine_1.stl")
