
import cadquery as cq

# Create the base square
base_square = cq.Workplane("XY").rect(1.5, 1.5).extrude(0.05)

# Create the smaller square on top of the base square
smaller_square = cq.Workplane("XY").workplane(offset=0.05).rect(1.25, 1.25).extrude(0.05)

# Combine the two squares
result = base_square.union(smaller_square)

# Export the result
result.val().exportStl("Refine_1.stl")
