
import cadquery as cq

# Define the dimensions of the book
book_thickness = 20.0
book_width = 100.0
book_height = 200.0

# Create the first half of the book
result = cq.Workplane("front").box(book_width, book_height, book_thickness)

# Create the second half of the book
result = result.add(cq.Workplane("front").transformed(offset=(book_width, 0, 0), rotate=(0, 0, 45)).box(book_width, book_height, book_thickness))

# Export the result
result.val().exportStl("Refine_1.stl")
