
import cadquery as cq

# Define the points for the irregular hexagon
points = [(0, 0), (1, 0), (0.8, 0.5), (0.2, 0.5), (0, 0)]

# Create the workplane and draw the hexagon
r = cq.Workplane("front").polyline(points)

# Extrude the hexagon
result = r.close().extrude(0.04)

# Export the result
result.val().exportStl("Refine_1.stl")
