
import cadquery as cq
import math

# Define the number of points and the radius of the star
num_points = 5
radius = 1.0

# Calculate the angle between each point
angle = 2.0 * math.pi / num_points

# Create the initial workplane
result = cq.Workplane("XY")

# Create the initial point
pnt = (radius, 0)

# Create the star
for i in range(num_points):
    # Calculate the next point
    next_pnt = (radius * math.cos((i + 1) * angle), radius * math.sin((i + 1) * angle))
    
    # Draw the line to the next point
    result = result.lineTo(*next_pnt)
    
    # Calculate the inner point
    inner_pnt = (radius/2 * math.cos((i + 1.5) * angle), radius/2 * math.sin((i + 1.5) * angle))
    
    # Draw the line to the inner point
    result = result.lineTo(*inner_pnt)

# Close the shape and extrude it
result = result.close().extrude(1.0)

# Export the result
result.val().exportStl("Refine_1.stl")
