
import cadquery as cq

# Create a cylinder
cylinder = cq.Workplane("XY").circle(0.48).extrude(0.3)

# Create a trapezium to cut out from the cylinder
trapezium = (
    cq.Workplane("XY")
    .moveTo(-0.02, 0.48)
    .lineTo(0.02, 0.48)
    .lineTo(0.01, 0.49)
    .lineTo(-0.01, 0.49)
    .close()
    .extrude(0.3)
)

# Cut the trapezium from the cylinder
result = cylinder.cut(trapezium)

result.val().exportStl("Refine_1.stl")
