
import cadquery as cq

# Define the dimensions
width = 90.0
height = 60.0
cutout_size = width / 3.0

# Create the large rectangle
result = cq.Workplane("front").rect(width, height)

# Create the square cutout
result = result.rect(cutout_size, cutout_size).extrude(cutout_size)

# Save the output
result.val().exportStl("Refine_1.stl")
