
import cadquery as cq

# Create the base rectangle
base = cq.Workplane("XY").box(0.75, 0.5, 0.75)

# Create the cutout rectangle
cutout = cq.Workplane("XY").workplane(offset=0.75/2).box(0.5, (2/3)*0.5, 0.75)

# Combine the base and the cutout
result = base.cut(cutout)

# Export the result
result.val().exportStl("Refine_2.stl")
