
import cadquery as cq

# Create the base plate
base_plate = cq.Workplane("XY").box(100, 50, 10)

# Create the hole
hole = (
    cq.Workplane("XY")
    .workplane(offset=2.5)
    .rect(25, 12.5)
    .extrude(-10)
)

# Combine the base and the hole
result = base_plate.cut(hole)

# Export the result
result.val().exportStl("Refine_1.stl")
