
import cadquery as cq

# Parameters for the cylinder and the cutout
outer_radius = 10
inner_radius = 9
angle_degrees = 60
extrude_height = 5

# Create the outer cylinder sector
outer_sector = (
    cq.Workplane("XY")
    .moveTo(0, 0)
    .radiusArc(endPoint=(outer_radius, 0), radius=outer_radius)
    .lineTo(0, 0)
    .close()
    .extrude(extrude_height)
)

# Create the inner cylinder sector
inner_sector = (
    cq.Workplane("XY")
    .moveTo(0, 0)
    .radiusArc(endPoint=(inner_radius, 0), radius=inner_radius)
    .lineTo(0, 0)
    .close()
    .extrude(extrude_height)
)

# Subtract the inner sector from the outer sector to create the hollow cylinder sector
result = outer_sector.cut(inner_sector)

# Export the result
result.val().exportStl("Refine_1.stl")
