
import cadquery as cq

# Create the main body of the whistle
cylinder = cq.Workplane("XY").circle(10).extrude(5)

# Create the rectangular block
block = cq.Workplane("XY").workplane(offset=5).rect(20, 2).extrude(1)

# Combine the cylinder and the block
whistle = cylinder.union(block)

# Export the result
whistle.val().exportStl("Refine_1.stl")
