
import cadquery as cq

# Parameters for the hexagonal head and the screw
head_diameter = 10.0
head_height = 5.0
screw_diameter = 4.0
screw_length = 20.0

# Create the hexagonal head
result = cq.Workplane("XY").polygon(6, head_diameter).extrude(head_height)

# Create the screw
result = result.faces(">Z").workplane().circle(screw_diameter / 2).extrude(screw_length)

# Export the result to STL
result.val().exportStl("Refine_2.stl")
