
import cadquery as cq

# Dimensions for the workbench
length = 90.0
width = 30.0
height = width
leg_length = length / 3
leg_width = width / 10
rod_diameter = leg_width - 2

# Create the top of the workbench
top = (
    cq.Workplane("XY")
    .box(length, width, height, centered=False)
)

# Create one leg of the workbench
leg = (
    cq.Workplane("XY")
    .box(leg_width, leg_width, leg_length, centered=False)
)

# Create the rod connecting the legs
rod = (
    cq.Workplane("XY")
    .moveTo(length/2, width/2)
    .circle(rod_diameter / 2)
    .extrude(leg_width)
)

# Reposition every components
top = top.translate((0, width/2, leg_length))
left_leg = leg.translate((length/3, width/2, leg_length/2))
right_leg = leg.translate((2*length/3, width/2, leg_length/2))
rod = rod.translate((0, 0, leg_width/2))

# Combine all parts
workbench = top.union(left_leg).union(right_leg).union(rod)

# Export the result
workbench.val().exportStl("Refine_2.stl")
