
import cadquery as cq

# Create the first hexagon and extrude it 
result = cq.Workplane("XY").polygon(6, 1.15).extrude(1.0)

# Create the second hexagon on top of the first one and extrude it
result = result.faces(">Z").workplane().polygon(6, 1.0).extrude(0.87)

# Create the third hexagon on top of the second one and extrude it
result = result.faces(">Z").workplane().polygon(6, 0.87).extrude(0.63)

# Finally, create a triangle on top of the third hexagon and extrude it
result = result.faces(">Z").workplane().polygon(3, 0.75).extrude(0.55)

# Export the result
result.val().exportStl("Refine_2.stl")
