
import cadquery as cq

# Define the points the spline will pass through
points = [
    (0, 0),
    (0.5, 0.5),
    (0.5, 1.5),
    (0, 2),
    (-0.5, 1.5),
    (-0.5, 0.5)
]

# Create a workplane, draw spline, mirror, and extrude it
result = (
    cq.Workplane("front")
    .spline(points).close()
    .mirrorY()
    .extrude(1)
)

# Export the result to STL
result.val().exportStl("Refine_1.stl")
