
import cadquery as cq

# Define the points the spline will pass through for half of the heart shape
points = [
    (-1, 0),
    (-2, -3),
    (0, -5),
    (2, -3),
    (1, 0)
]

# Create a heart shape, draw spline for half, mirror it for other half, and extrude it
result = (
    cq.Workplane("front")
    .spline(points).mirrorY()
    .extrude(1)
)

# Export the result to STL
result.val().exportStl("Refine_2.stl")
