
import cadquery as cq

# Define the dimensions
base = 10.0
height = 22.0
thickness = 0.5

# Create the sketch
result = (
    cq.Workplane("front")
    .moveTo(0, 0)
    .lineTo(base, 0)
    .lineTo(0, height)
    .close()
    .offset2D(-thickness)
    .extrude(thickness)
)

# Export the result
result.val().exportStl("Generated.stl")
