
import cadquery as cq

# Define dimensions
cylinder_radius = 5
cylinder_height = 20
circle_radius = 10
circle_height = 5

# Create a cylinder
cylinder = cq.Workplane("XY").circle(cylinder_radius).extrude(cylinder_height)

# Create a circle larger than the cylinder's size and place it near the top of the cylinder
circle = cq.Workplane("XY").workplane(offset=cylinder_height - 2).circle(circle_radius).extrude(circle_height)

# Combine the cylinder and the circle
result = cylinder.union(circle)

# Save the output
result.val().exportStl("Refine_2.stl")
