
import cadquery as cq

# Define the dimensions of the rectangle and the holes
length = 1.5  # Length of the rectangle
width = 0.55  # Width of the rectangle
thickness = 0.02  # Thickness of the rectangle
hole_dia = 0.01  # Diameter of the holes

# Create the rectangle
result = cq.Workplane("XY").box(length, width, thickness)

# Cut the holes
for i in range(3):
    result = result.faces(">Z").workplane().pushPoints([(0.1 + i * 0.2, 0.1)]).hole(hole_dia)

# Export the result
result.val().exportStl("Refine_2.stl")
