
import cadquery as cq

# Create a square
result = cq.Workplane("front").rect(1, 1)

# Attach a semi-circle to the top of the square
result = result.moveTo(0, 0.5).threePointArc((0.5, 1), (1, 0.5))

# Extrude the sketch
result = result.close().extrude(1)

# Save the output
result.val().exportStl("Generated.stl")
