
import cadquery as cq

# Create a square
result = cq.Workplane("front").rect(0.87, 0.87)

# Attach a semi-circle to the top of the square
result = result.moveTo(0, 0.435).threePointArc((0.435, 0.87), (0.87, 0.435))

# Extrude the sketch
result = result.close().extrude(0.15)

# Save the output
result.val().exportStl("Refine_1.stl")
