
import cadquery as cq

# Create a square
result = cq.Workplane("front").rect(1.31, 1.31)

# Attach a semi-circle to the top of the square
result = result.moveTo(0, 0.655).threePointArc((0.655, 1.31), (1.31, 0.655))

# Extrude the sketch
result = result.close().extrude(0.15)

# Save the output
result.val().exportStl("Refine_2.stl")
