
import cadquery as cq

# Define the dimensions of the trapezoid
base_length = 10.0
top_length = 6.0
height = 8.0
thickness = 2.0

# Define the dimensions of the hole
hole_base_length = 8.0
hole_top_length = 5.0
hole_height = 6.0

# Create the trapezoid
trapezoid = (
    cq.Workplane("XY")
    .lineTo(base_length / 2, 0)
    .lineTo(top_length / 2, height)
    .lineTo(-top_length / 2, height)
    .lineTo(-base_length / 2, 0)
    .close()
    .extrude(thickness)
)

# Create the hole
hole = (
    cq.Workplane("XY")
    .moveTo((base_length - hole_base_length) / 2, (height - hole_height) / 2)
    .lineTo(hole_base_length / 2, 0)
    .lineTo(hole_top_length / 2, hole_height)
    .lineTo(-hole_top_length / 2, hole_height)
    .lineTo(-hole_base_length / 2, 0)
    .close()
    .extrude(thickness)
)

# Subtract the hole from the trapezoid
result = trapezoid.cut(hole)

# Export the result
result.val().exportStl("Refine_2.stl")
