
import cadquery as cq

# Define the dimensions of the trapezoid
base1 = 0.23
base2 = 0.74
height = 0.5
thickness = 0.06

# Create the trapezoid sketch
result = (
    cq.Workplane("front")
    .moveTo(-base2 / 2.0, 0)
    .lineTo(-base1 / 2.0, height)
    .lineTo(base1 / 2.0, height)
    .lineTo(base2 / 2.0, 0)
    .close()
)

# Extrude the sketch to create the prism
result = result.extrude(thickness)

# Export the result
result.val().exportStl("Refine_1.stl")
