
import cadquery as cq

# Create a rectangle
rectangle = cq.Workplane("XY").rect(11.5, 2).extrude(1)

# Create two cylinders on one end of the rectangle
cylinder1 = cq.Workplane("XY").workplane(offset=1).center(-4, 0).circle(0.5).extrude(1)
cylinder2 = cq.Workplane("XY").workplane(offset=1).center(-6, 0).circle(0.5).extrude(1)

# Combine the rectangle and the cylinders
result = rectangle.union(cylinder1).union(cylinder2)

# Export the result
result.val().exportStl("Refine_1.stl")
