
import cadquery as cq

# Create a rectangle
rectangle = cq.Workplane("XY").rect(20, 10).extrude(1)

# Create two cylinders on one end of the rectangle
cylinder1 = cq.Workplane("XY").workplane(offset=1).center(-5, 0).circle(1).extrude(1)
cylinder2 = cq.Workplane("XY").workplane(offset=1).center(-15, 0).circle(1).extrude(1)

# Combine the rectangle and the cylinders
result = rectangle.union(cylinder1).union(cylinder2)

# Export the result
result.val().exportStl("Refine_2.stl")
