
import cadquery as cq

# Define the dimensions
rect_length = 30.0
rect_width = 10.0
semi_hex_length = rect_length * 2 / 3
semi_hex_height = rect_width / 2

# Create the rectangle
refine = cq.Workplane("front").rect(rect_length, rect_width)

# Create the semi-hexagon
refine = refine.moveTo(rect_length, 0).lineTo(rect_length + semi_hex_length / 2, semi_hex_height)
refine = refine.lineTo(rect_length + semi_hex_length, 0).lineTo(rect_length, 0)

# Extrude the sketch
refine = refine.extrude(rect_width)

# Export the result
refine.val().exportStl("Refine_2.stl")
