
import cadquery as cq

# Define the dimensions
width = 20.0
height = width / 20
square_side = width / 2
extrude_depth = width * 20

# Create base rectangle
base = cq.Workplane("front").rect(width, height).extrude(extrude_depth)

# Create the first square
first_square = cq.Workplane("front").workplane(offset=height).rect(square_side, square_side)\
    .extrude(extrude_depth)

# Create the second square
second_square = cq.Workplane("front").workplane(offset=2*height).rect(square_side*0.99, square_side*0.99)\
    .extrude(extrude_depth)

# Subtract the squares from the base
result = base.cut(first_square).cut(second_square)

# Export the result
result.val().exportStl("Generated.stl")
